LIBNAME SASDAT 'C:\My Documents\jap_sem\Analyses\3vpower_lat';
Title 'Power analysis for 3 indicator models for JAP SEM paper';
/* Program: 3ind_power1.sas*/



proc calis cov data=setup outstat=init_dat NOBS=&N PCORR noprint;
var X1-X3 Y1-Y3 Z1-Z3;
lineqs
X1 = &LD F1 + EX1,               
X2 = &LD F1 + EX2,
X3 = &LD F1 + EX3,               
Y1 = &LD F2 + EY1,
Y2 = &LD F2 + EY2,	                   
Y3 = &LD F2 + EY3,
Z1 = &LD F3 + EZ1,
Z2 = &LD F3 + EZ2,
Z3 = &LD F3 + EZ3,
F2 = &lag1 F1 + D1,
F3 = &lag1 F2 + &lag2 F1 + D2;
STD
EX1-EX3 EY1-EY3 EZ1-EZ3=9*&thet,
F1=&lat_sig,
D1=&ps_11,
D2=&ps_22;
run;

data dum1;
set init_dat;
if _type_= 'MAXPRED';
if _type_= 'MAXPRED' then _type_ = 'COV';

data dum2 (TYPE=COV);
set dum1;
if _n_ gt 9 then delete;

proc calis cov data=dum2 NOBS=&N PCORR outram=ramtry noprint;
VAR X1-X3 Y1-Y3 Z1-Z3;
lineqs
X1 = &LD F1 + EX1,               
X2 = LX21 F1 + EX2,
X3 = LX31 F1 + EX3,               
Y1 = &LD F2 + EY1,
Y2 = LY21 F2 + EY2,	                   
Y3 = LY31 F2 + EY3,
Z1 = &LD F3 + EZ1,
Z2 = LY52 F3 + EZ2,
Z3 = LY62 F3 + EZ3,
F2 = P1 F1 + D1,
F3 = P2 F2 + D2;
STD
EX1-EX3 EY1-EY3 EZ1-EZ3=THE1-THE9,
F1=KSI_11,
D1=PS_11,
D2=PS_22;
run;

data tryram;
set ramtry;
if _type_ = 'STAT' and _name_ = 'FIT';
KEEP LOAD LAG2 NUM_IND FIT ;
LOAD = &LD;
NUM_IND = &NUM_IND;
LAG2=&LAG2;
FIT = _ESTIM_;

%if &count = 1 %then %do;
data sumar;
set tryram;
run;
%end;
%else %do;
PROC APPEND BASE=SUMAR DATA=TRYRAM ;
run;
%end;

%end;
%end;

%mend;

data setup (TYPE=COV) ;
_type_ = 'cov';
input _name_ $ X1-X4 Y1-Y4 Z1-Z4;
datalines;
X1 1.00   .   .    .    .    .    .    .    .  .  .  .  
X2 .50  1.00  .    .    .    .    .    .    .  .  .  .  
X3 .50  .50  1.00  .    .    .    .    .    .  .  .  .  
X4 .50  .50  .50  1.00  .    .    .    .    .  .  .  .  
Y1 .50  .50  .50  .50   1.00 .    .    .    .  .  .  .  
Y2 .50  .50  .50  .50  .50  1.00    .  .    .  .  .  .
Y3 .50  .50  .50  .50  .50  .50   1.00   .  .   .  .   . 
Y4 .50  .50  .50  .50  .50  .50   .50  1.00 .   .  .   .
Z1 .50  .50  .50  .50  .50  .50   .50  .50 1.00 .  .  .
Z2 .50  .50  .50  .50  .50  .50  .50   .50 .50 1.00 . .
Z3 .50  .50  .50  .50  .50  .50  .50   .50 .50  .50 1.00 .
Z4 .50  .50  .50  .50  .50  .50  .50   .50 .50  .50 .50 1.00 
;
%let count=0;
%GENCOV;
data let_see;
set sumar;
proc print;
run;

data SASDAT.POW3IN;
set sumar;
df1=1;
df2=25;
CRIT1 = CINV(.95,DF1);
CRIT2 = CINV(.95,DF2);

do N = 100 to 1000 by 50;
LAMBDA = (N-1)*FIT;
POWER1 = (1-(PROBCHI(CRIT1,DF1, LAMBDA)));
POWER2 = (1-(PROBCHI(CRIT2,DF2, LAMBDA)));
OUTPUT;
end;

proc print;
run;


