LIBNAME SASDAT 'C:\My Documents\jap_sem\Analyses\3vpower_lat';
Title 'Power analysis for 3 indicator models for JAP SEM paper';
/* Program: 3ind_power1.sas*/

%Macro GENCOV;
%let LD_DUM = 7;
%let lag2_DUM = 20;
%let LD = %sysevalf(&LD_DUM/10);
%let lag2 = %sysevalf(&lag2_DUM/100);
%let N=500;
%let NUM_IND = 3;
%let nksi = 1;
%let neta = 2;
%let nfact =%sysevalf(&nksi + &neta);
%let lat_sig = 1;
%let obs_sig = 1;
%let lag1 = .6;
%let thet = %sysevalf(&obs_sig - ((&LD**2)*&lat_sig));
%let ps_11 = %sysevalf(1 -((&lag1**2)*&lat_sig));
%let ps_22 = %sysevalf(1 - ((&lag1**2)*&lat_sig) - ((&lag2**2)*&lat_sig) -(2*(&lag1**2)*&lag2));
%let DF1 = 1;
%let DF2 = 25;

proc calis cov data=setup outstat=init_dat NOBS=&N PCORR noprint;
var X1-X3 Y1-Y3 Z1-Z3;
lineqs
X1 = &LD F1 + EX1,               
X2 = &LD F1 + EX2,
X3 = &LD F1 + EX3,               
Y1 = &LD F2 + EY1,
Y2 = &LD F2 + EY2,	                   
Y3 = &LD F2 + EY3,
Z1 = &LD F3 + EZ1,
Z2 = &LD F3 + EZ2,
Z3 = &LD F3 + EZ3,
F2 = &lag1 F1 + D1,
F3 = &lag1 F2 + &lag2 F1 + D2;
STD
EX1-EX3 EY1-EY3 EZ1-EZ3=9*&thet,
F1=&lat_sig,
D1=&ps_11,
D2=&ps_22;
run;

data dum1;
set init_dat;
if _type_= 'MAXPRED';
if _type_= 'MAXPRED' then _type_ = 'COV';

data dum2 (TYPE=COV);
set dum1;
if _n_ gt 9 then delete;

proc calis cov data=dum2 NOBS=&N PCORR outram=ramtry mod;
VAR X1-X3 Y1-Y3 Z1-Z3;
lineqs
X1 = &LD F1 + EX1,               
X2 = LX21 F1 + EX2,
X3 = LX31 F1 + EX3,               
Y1 = &LD F2 + EY1,
Y2 = LY21 F2 + EY2,	                   
Y3 = LY31 F2 + EY3,
Z1 = &LD F3 + EZ1,
Z2 = LY52 F3 + EZ2,
Z3 = LY62 F3 + EZ3,
F2 = P1 F1 + D1,
F3 = P2 F2 + D2;
STD
EX1-EX3 EY1-EY3 EZ1-EZ3=THE1-THE9,
F1=KSI_11,
D1=PS_11,
D2=PS_22;
COV
D1 D2 = CR1;
run;

%mend;

data setup (TYPE=COV) ;
_type_ = 'cov';
input _name_ $ X1-X4 Y1-Y4 Z1-Z4;
datalines;
X1 1.00   .   .    .    .    .    .    .    .  .  .  .  
X2 .50  1.00  .    .    .    .    .    .    .  .  .  .  
X3 .50  .50  1.00  .    .    .    .    .    .  .  .  .  
X4 .50  .50  .50  1.00  .    .    .    .    .  .  .  .  
Y1 .50  .50  .50  .50   1.00 .    .    .    .  .  .  .  
Y2 .50  .50  .50  .50  .50  1.00    .  .    .  .  .  .
Y3 .50  .50  .50  .50  .50  .50   1.00   .  .   .  .   . 
Y4 .50  .50  .50  .50  .50  .50   .50  1.00 .   .  .   .
Z1 .50  .50  .50  .50  .50  .50   .50  .50 1.00 .  .  .
Z2 .50  .50  .50  .50  .50  .50  .50   .50 .50 1.00 . .
Z3 .50  .50  .50  .50  .50  .50  .50   .50 .50  .50 1.00 .
Z4 .50  .50  .50  .50  .50  .50  .50   .50 .50  .50 .50 1.00 
;
%GENCOV;
run;
quit;

