LIBNAME SASDAT 'C:\My Documents\jap_sem\Analyses\3vpower_lat';
Title 'Power analysis for 3 indicator models for JAP SEM paper';
/* Program: 3ind_power1.sas*/
data setup (TYPE=COV) ;
_type_ = 'cov';
input _name_ $ X1-X3 Y1-Y3 Z1-Z3;
datalines;
  X1       1.00  . . . . . . . .
  X2       0.49  1.00 . . . . . . .     
  X3       0.49  .49   1.00  . . . . . .    
  Y1       0.294 .294  .294  1.00 . . . . .       
  Y2       0.294 .294  .294  .49    1.00 . . . .
  Y3       0.294  .294  .294 .49    .49  1.00 . . .
  Z1       0.2744 .2744 .2744 .3528 .3528 .3528 1.00 . .
  Z2       0.2744 .2744 .2744 .3528 .3528 .3528 .49 1.00 .
  Z3       0.2744 .2744 .2744 .3528 .3528 .3528 .49 .49 1.00





proc calis cov data=dum2 NOBS=&N PCORR outram=ramtry ;
VAR X1-X3 Y1-Y3 Z1-Z3;
lineqs
X1 = &LD F1 + EX1,               
X2 = LX21 F1 + EX2,
X3 = LX31 F1 + EX3,               
Y1 = &LD F2 + EY1,
Y2 = LY21 F2 + EY2,	                   
Y3 = LY31 F2 + EY3,
Z1 = &LD F3 + EZ1,
Z2 = LY52 F3 + EZ2,
Z3 = LY62 F3 + EZ3,
F2 = P1 F1 + D1,
F3 = P2 F2 + D2;
STD
EX1-EX3 EY1-EY3 EZ1-EZ3=THE1-THE9,
F1=KSI_11,
D1=PS_11,
D2=PS_22;
run;
