LIBNAME SASDAT 'C:\My Documents\jap_sem\Analyses\3vpower_lat';
Title 'Model that fits poorly with really strong effects for JAP SEM paper';
/* Program: weak_effect_model.sas*/
data setup (TYPE=COV) ;
_type_ = 'cov';
input _name_ $ X1 X2 X3 X4;
datalines;
X1 100  .   .    .    
X2 30 100  .    .    
X3 6.5 6.5  100 .   
X4 .52 .52 8  100 
;

proc calis cov data=setup outstat=init_dat NOBS=500 PCORR;
var X1-X4;
lineqs
X3 = P31 X1 + P32 X2 + EX3,               
X4 = P43 X3 + EX4;
STD
EX3 = VER_X3,
EX4 = VER_X4,
X1 = V_X1,
X2 = V_X2;
COV
X1 X2 = C_X1X2;
run;

/*
proc calis cov data=setup outstat=init_dat NOBS=500 PCORR;
var X1-X4;
lineqs
X3 = P31 X1 + P32 X2 + EX3,               
X4 = P43 X3 + EX4;
STD
EX3 = VER_X3,
EX4 = VER_X4,
X1 = V_X1,
X2 = V_X2;
COV
X1 X2 = C_X1X2;
run;
*/