LIBNAME SASDAT 'C:\My Documents\jap_sem\Analyses\3vpower_lat';
Title 'Model that fits poorly with really strong effects for JAP SEM paper';
/* Program: strong_effect_model.sas*/
data setup (TYPE=COV) ;
_type_ = 'cov';
input _name_ $ X1-X4;
datalines;
X1 100   .   .    .    
X2 20  100  .    .    
X3 55 65  100  .   
X4 65 75 80   100
;

/*
proc calis cov data=setup outstat=init_dat NOBS=500 PCORR;
var X1-X4;
lineqs
X3 = P31 X1 + P32 X2 + EX3,               
X4 = P41 X1 + P42 X2 + P43 X3 + EX4;
STD
EX3 = VER_X3,
EX4 = VER_X4,
X1 = V_X1,
X2 = V_X2;
COV
X1 X2 = C_X1X2;
run;
*/

proc calis cov data=setup outstat=init_dat NOBS=500 PCORR;
var X1-X4;
lineqs
X3 = P31 X1 + P32 X2 + EX3,               
X4 = P43 X3 + EX4;
STD
EX3 = VER_X3,
EX4 = VER_X4,
X1 = V_X1,
X2 = V_X2;
COV
X1 X2 = C_X1X2;
run;