%let LD = .7;
%let lag2 = .4;
%let N=300;
%let lat_sig = 1;
%let obs_sig = 1;
%let lag1 = .6;
%let thet = %sysevalf(&obs_sig - ((&LD**2)*&lat_sig));
%let ps_11 = %sysevalf(1 -((&lag1**2)*&lat_sig));
%let ps_22 = %sysevalf(1 - ((&lag1**2)*&lat_sig) - ((&lag2**2)*&lat_sig) -(2*(&lag1**2)*&lag2));
data setup (TYPE=COV) ;
_type_ = 'cov';
input _name_ $ X1-X4 Y1-Y4 Z1-Z4;
datalines;
X1 1.00   .   .    .    .    .    .    .    .  .  .  .  
X2 .50  1.00  .    .    .    .    .    .    .  .  .  .  
X3 .50  .50  1.00  .    .    .    .    .    .  .  .  .  
X4 .50  .50  .50  1.00  .    .    .    .    .  .  .  .  
Y1 .50  .50  .50  .50   1.00 .    .    .    .  .  .  .  
Y2 .50  .50  .50  .50  .50  1.00    .  .    .  .  .  .
Y3 .50  .50  .50  .50  .50  .50   1.00   .  .   .  .   . 
Y4 .50  .50  .50  .50  .50  .50   .50  1.00 .   .  .   .
Z1 .50  .50  .50  .50  .50  .50   .50  .50 1.00 .  .  .
Z2 .50  .50  .50  .50  .50  .50  .50   .50 .50 1.00 . .
Z3 .50  .50  .50  .50  .50  .50  .50   .50 .50  .50 1.00 .
Z4 .50  .50  .50  .50  .50  .50  .50   .50 .50  .50 .50 1.00 
;
proc calis cov data=setup outstat=ind4 NOBS=&N PCORR;
title '4 indicator case';
lineqs
X1 = &LD F1 + EX1,               
X2 = &LD F1 + EX2,
X3 = &LD F1 + EX3,
X4 = &LD F1 + EX4, 
Y1 = &LD F2 + EY1,
Y2 = &LD F2 + EY2,	                   
Y3 = &LD F2 + EY3,
Y4 = &LD F2 + EY4,
Z1 = &LD F3 + EZ1,
Z2 = &LD F3 + EZ2,
Z3 = &LD F3 + EZ3,
Z4 = &LD F3 + EZ4,
F2 = &lag1 F1 + D1,
F3 = &lag1 F2 + &lag2 F1 + D2;
STD
EX1-EX4 EY1-EY4 EZ1-EZ4=12*&thet,
F1=&lat_sig,
D1=&ps_11,
D2=&ps_22;
run;

proc calis cov data=setup outstat=ind2 NOBS=&N PCORR;
title '2 indicator case';
VAR X1-X2 Y1-Y2 Z1-Z2;
lineqs
X1 = &LD F1 + EX1,               
X2 = &LD F1 + EX2,
Y1 = &LD F2 + EY1,
Y2 = &LD F2 + EY2,	                   
Z1 = &LD F3 + EZ1,
Z2 = &LD F3 + EZ2,
F2 = &lag1 F1 + D1,
F3 = &lag1 F2 + &lag2 F1 + D2;
STD
EX1-EX2 EY1-EY2 EZ1-EZ2=6*&thet,
F1=&lat_sig,
D1=&ps_11,
D2=&ps_22;
run;


data try4;
set ind4;
if _type_='MAXPRED';
if _type_='MAXPRED' then _type_='COV';
proc print;
run;

data try2;
set ind2;
if _type_='MAXPRED';
if _type_='MAXPRED' then _type_='COV';
proc print;
run;