
/*Program to generate power curves for t test*/

/*Title of graph*/
title h = 1.6 f=duplex "Power of the t-test alpha = .05 ",
f=duplex "1 tailed";

data tpower;

/*create labels for variables*/

label  n = 'Sample size per group';
       	   df = 'Degrees of Freedom';

do n = 5 to 20 by 5, 30 to 70 by 10; 
	df = 2*(n-1);
	do cohen_d = .1 to .9 by .1;

		/* noncentral t value derived from value of cohen d*/
		nc_t = sqrt(n/2) * cohen_d;

		/*compute critical t value -- value that 95% of scores are below in central
		t distribution with df degrees of freedom*/
		crit_t = tinv(.95, df, 0);

		/*power calculation -- what's the probability
		of getting a t value greater than the critical t value
        if the reference distribution is the noncentral t dist with df degrees of 
		freedom and a ncp = nc_t */
		power = 1 - probt(crit_t, df, nc_t);
		output;
	end;
end;

proc print;
run;

/*now create plotting symbols*/
symbol1 i=spline v=star l=1 c=red;
symbol2 i=spline v=+ l=2 c=blue;
symbol3 i=spline v=- l=5 c=green;
symbol4 i=spline v=plus l=8 c=red;
symbol5 i=spline v=$ l=12 c=blue;
symbol6 i=spline v=: l=16 c=green;
symbol7 i=spline v=@ l=12 c=red;
symbol8 i=spline v=square l=22 c=blue;
symbol9 i=spline v=triangle l=25 c=green;

proc gplot data=tpower;
plot power * n = cohen_d
 /vaxis = axis1 haxis=axis2
 vref = .8 lvref=25 cvref=black
 hminor=1 frame
 legend=legend1
 ;
axis1 order = (0 to 1 by .1)
	label = (a=90 r=0 h=1.4)
	value = (h=1.4);
axis2 offset = (2)
	order = (5 to 70 by 5)
	label=(h=1.4)
	value=(h=1.4);
legend1 label = (h=1.4 'Effect Size') value = (h=1.4);
run;

