/*Note to self: Write macro that varies N, value of c, loadings */
/*Maybe easiest at this point to write different programs for different indicators --
e.g., 2,4,6*/


data Wheaton(TYPE=COV);                                             
   title "Stability of Alienation";                                    
   title2 "Data Matrix of WHEATON, MUTHEN, ALWIN & SUMMERS (1977)";    
      _type_ = 'cov'; input _name_ $ v1-v6;                            
      label v1='Anomia (1967)' v2='Anomia (1971)' v3='Education'       
            v4='Powerlessness (1967)' v5='Powerlessness (1971)'        
            v6='Occupational Status Index';                            
      datalines;                                                       
   v1   11.834     .        .        .       .        .                
   v2    6.947    9.364     .        .       .        .                
   v3    6.819    5.091   12.532     .       .        .                
   v4    4.783    5.028    7.495    9.986    .        .                
   v5   -3.839   -3.889   -3.841   -3.625   9.610     .                
   v6  -21.899  -18.831  -21.748  -18.775  35.522  450.288             
   ;                                                                   
                                                                       
   proc calis cov data=Wheaton tech=nr edf=931 /*pall*/ outstat=try;                   
      Lineqs                                                             
         V1 =         F1                  + E1,                        
         V2 =    .833 F1                  + E2,                        
         V3 =         F2                  + E3,                        
         V4 =    .833 F2                  + E4,                        
         V5 =         F3                  + E5,                        
         V6 = Lamb (.5) F3                + E6,                        
         F1 = Gam1(-.5) F3                + D1,                        
         F2 = Beta (.5) F1 + Gam2(-.5) F3 + D2;                        
      Std                                                                
         E1-E6 = The1-The2 The1-The4 (6 * 3.),                         
         D1-D2 = Psi1-Psi2 (2 * 4.),                                   
         F3    = Phi (6.) ;                                            
      Cov                                                                
         E1 E3 = The5 (.2),                                            
         E4 E2 = The5 (.2);                                            
   run;

data try2;
set try;
if _type_= 'MAXPRED'and ((_NAME_ NE 'F1')and (_NAME_ NE 'F2') and 
(_NAME_ NE 'F3'));
if _type_= 'MAXPRED' then _type_='COV';

/*
%let dsid=%sysfunc(open(try2,i));
%let obsnum=%sysfunc(curobs(&dsid));
&if &obsnum > 6 then &delete;
*/

proc print;
run;

proc calis cov data=try2(type = cov) tech=nr edf=931 ;                   
      Lineqs                                                             
         V1 =         F1                  + E1,                        
         V2 =    .833 F1                  + E2,                        
         V3 =         F2                  + E3,                        
         V4 =    .833 F2                  + E4,                        
         V5 =         F3                  + E5,                        
         V6 = Lamb (.5) F3                + E6,                        
         F1 = Gam1(-.5) F3                + D1,                        
         F2 = Beta (.5) F1 + Gam2(-.5) F3 + D2;                        
      Std                                                                
         E1-E6 = The1-The2 The1-The4 (6 * 3.),                         
         D1-D2 = Psi1-Psi2 (2 * 4.),                                   
         F3    = Phi (6.) ;                                            
      Cov                                                                
         E1 E3 = The5 (.2),                                            
         E4 E2 = The5 (.2);                                            
   run;
