options symbolgen;

data try;
%let loading = 1;
%let n_indic = 2;
%let nksi = 1;
%let neta = 2;
%let nfact =%sysevalf(&nksi + &neta);
%let lat_sig = 1;
%let obs_sig = 2;
%let lag_1 = .6;
%let lag_2 = .30;
%let thet = %sysevalf(&obs_sig - ((&loading**2)*&lat_sig));
%let ps_11 = %sysevalf(1 -((&lag_1**2)*&lat_sig));
%let ps_22 = %sysevalf(1 - ((&lag_1**2)*&lat_sig) - ((&lag_2**2)*&lat_sig) -(2*(&lag_1**2)*&lag_2));
%put &thet &ps_11 &ps_22;

proc iml;
loading=1;
n_indic=2;
nksi=1;
neta=2;
nfact = nksi*neta;
lat_sig = 1;
obs_sig = 2;
LX ={1, 1};
LY={1 0, 1 0, 0 1, 0 1};
TD=&thet#I(2);
TE=&thet#I(4);
PHI={1};
PSI={&ps_11 0, 0 &ps_22};
GA ={&lag_1, &lag_2};
BE = {0 0,&lag_1 0};
A = INV(I(2)-BE);
print LX LY TD TE PHI PSI GA BE A;
UL = LY*A*(GA*PHI*GA`+ PSI)*A`*LY`+ TE;
LL= LX*PHI*GA`*A`*LY`;
UR = LL`;
LR= LX*PHI*LX`+TD;
LEFT=UL//LL;
RIGHT=UR//LR;
COV_MAT=LEFT||RIGHT;
LTCOV=COV_MAT;

DO R = 1 to 6;
DO C = 1 to 6;
IF C>R then LTCOV [R,C]=0;
else LTCOV[R,C]=COV_MAT[R,C];
END;
END;
v_name = {'Y1', 'Y2', 'Z1', 'Z2', 'X1', 'X2'};
NCOV_MAT= v_name||COV_MAT;
print COV_MAT LTCOV;
run;


