LIBNAME SASDAT 'C:\My Documents\jap_sem\Analyses\3vpower_lat';
Title 'Power analysis for 4 indicator models for JAP SEM paper';
/* Program: 4ind_power1.sas*/

%Macro GENCOV;
%do LD_DUM = 3 %to 9 %by 1;
%do lag2_DUM = 5 %to 50 %by 5;
%let LD = %sysevalf(&LD_DUM/10);
%let lag2 = %sysevalf(&lag2_DUM/100);
%let count = %sysevalf(&count + 1);
%let N=100;
%let NUM_IND = 4;
%let nksi = 1;
%let neta = 2;
%let nfact =%sysevalf(&nksi + &neta);
%let lat_sig = 1;
%let obs_sig = 1;
%let lag1 = .6;
%let thet = %sysevalf(&obs_sig - ((&LD**2)*&lat_sig));
%let ps_11 = %sysevalf(1 -((&lag1**2)*&lat_sig));
%let ps_22 = %sysevalf(1 - ((&lag1**2)*&lat_sig) - ((&lag2**2)*&lat_sig) -(2*(&lag1**2)*&lag2));
%let DF1 = 1;
%let DF2 = 25;

proc calis cov data=setup outstat=init_dat NOBS=&N PCORR noprint;
var X1-X4 Y1-Y4 Z1-Z4;
lineqs
X1 = &LD F1 + EX1,               
X2 = &LD F1 + EX2,
X3 = &LD F1 + EX3,   
X4 = &LD F1 + EX4, 
Y1 = &LD F2 + EY1,
Y2 = &LD F2 + EY2,	                   
Y3 = &LD F2 + EY3,
Y4 = &LD F2 + EY4,
Z1 = &LD F3 + EZ1,
Z2 = &LD F3 + EZ2,
Z3 = &LD F3 + EZ3,
Z4 = &LD F3 + EZ4,
F2 = &lag1 F1 + D1,
F3 = &lag1 F2 + &lag2 F1 + D2;
STD
EX1-EX4 EY1-EY4 EZ1-EZ4=12*&thet,
F1=&lat_sig,
D1=&ps_11,
D2=&ps_22;
run;

data dum1;
set init_dat;
if _type_= 'MAXPRED';
if _type_= 'MAXPRED' then _type_ = 'COV';

data dum2 (TYPE=COV);
set dum1;
if _n_ gt 12 then delete;

proc calis cov data=dum2 NOBS=&N PCORR outram=ramtry noprint;
VAR X1-X4 Y1-Y4 Z1-Z4;
lineqs
X1 = &LD F1 + EX1,               
X2 = LX21 F1 + EX2,
X3 = LX31 F1 + EX3,  
X4 = LX41 F1 + EX4, 
Y1 = &LD F2 + EY1,
Y2 = LY21 F2 + EY2,	                   
Y3 = LY31 F2 + EY3,
Y4 = LY41 F2 + EY4,
Z1 = &LD F3 + EZ1,
Z2 = LY62 F3 + EZ2,
Z3 = LY72 F3 + EZ3,
Z4 = LY82 F3 + EZ4,
F2 = P1 F1 + D1,
F3 = P2 F2 + D2;
STD
EX1-EX4 EY1-EY4 EZ1-EZ4=THE1-THE12,
F1=KSI_11,
D1=PS_11,
D2=PS_22;
run;

data tryram;
set ramtry;
if _type_ = 'STAT' and _name_ = 'FIT';
KEEP LOAD LAG2 NUM_IND FIT ;
LOAD = &LD;
NUM_IND = &NUM_IND;
LAG2=&LAG2;
FIT = _ESTIM_;

%if &count = 1 %then %do;
data sumar;
set tryram;
run;
%end;
%else %do;
PROC APPEND BASE=SUMAR DATA=TRYRAM ;
run;
%end;

%end;
%end;

%mend;

data setup (TYPE=COV) ;
_type_ = 'cov';
input _name_ $ X1-X4 Y1-Y4 Z1-Z4;
datalines;
X1 1.00   .   .    .    .    .    .    .    .  .  .  .  
X2 .50  1.00  .    .    .    .    .    .    .  .  .  .  
X3 .50  .50  1.00  .    .    .    .    .    .  .  .  .  
X4 .50  .50  .50  1.00  .    .    .    .    .  .  .  .  
Y1 .50  .50  .50  .50   1.00 .    .    .    .  .  .  .  
Y2 .50  .50  .50  .50  .50  1.00    .  .    .  .  .  .
Y3 .50  .50  .50  .50  .50  .50   1.00   .  .   .  .   . 
Y4 .50  .50  .50  .50  .50  .50   .50  1.00 .   .  .   .
Z1 .50  .50  .50  .50  .50  .50   .50  .50 1.00 .  .  .
Z2 .50  .50  .50  .50  .50  .50  .50   .50 .50 1.00 . .
Z3 .50  .50  .50  .50  .50  .50  .50   .50 .50  .50 1.00 .
Z4 .50  .50  .50  .50  .50  .50  .50   .50 .50  .50 .50 1.00 
;
%let count=0;
%GENCOV;
data let_see;
set sumar;
proc print;
run;

data SASDAT.POW4IN;
set sumar;
df1=1;
df2=52;
CRIT1 = CINV(.95,DF1);
CRIT2 = CINV(.95,DF2);

do N = 100 to 1000 by 50;
LAMBDA = (N-1)*FIT;
POWER1 = (1-(PROBCHI(CRIT1,DF1, LAMBDA)));
POWER2 = (1-(PROBCHI(CRIT2,DF2, LAMBDA)));
OUTPUT;
end;

proc print;
run;


